\version "2.24.0"
\language "deutsch"

\paper {
 between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 21))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  %system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Stille Nacht"
  subtitle = " "
  subsubtitle = " "
  poet = "Josef Mohr (1792–1848), 1816"
  composer = "Franz Gruber (1787–1863), 1818"
  arranger =  "Eusebie Mandicevschi (1857–1929)"
  meter = "Ziemlich langsam"
  tagline = ""
}

global = {
  %#(set-global-staff-size 18.5)
  \key c \major
  \time 6/8
  %\partial 4
  %\override Staff.TimeSignature.stencil = ##f
  %\set Timing.measureBarType = ""
  %\set Score.barNumberVisibility = ##f
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOn
}


altWordsOne = \lyricmode {
 \set stanza = "1." 
 Stil -- le Nacht! Hei -- li -- ge Nacht!
 Al -- les schläft, ein -- sam wacht
 nur das trau -- te hoch -- hei -- li -- ge Paar.
 Hol -- der Kna -- be im lo -- cki -- gen Haar,
 schlaf' in himm -- li -- scher Ruh', __
 schlaf' in himm -- li -- scher Ruh'! __
}


altWordsTwo = \lyricmode {
 \set stanza = "2." 
 Stil -- le Nacht! Hei -- li -- ge Nacht!
 Got -- tes Sohn, o wie lacht
 lieb' aus dei -- \skip1 nem gött -- li -- chen Mund,
 da uns schlägt \skip1 die ret -- ten -- de Stund':
 Christ in dei -- ner Ge -- burt, __
 Christ in dei -- ner Ge -- burt. __
}

altWordsThree = \lyricmode {
 \set stanza = "3." 
 Stil -- le Nacht! Hei -- li -- ge Nacht!
 Hir -- ten erst kund -- ge -- macht,
 durch der En -- gel Hal -- le -- \skip 1 lu -- ja.
 Tönt es la -- ut von fern __ \skip1 und nah:
 Christ, der Ret -- ter ist da, __
 Christ, der Ret -- ter ist da! __
}

sopMusic = \relative c'' {
  g8.( a16) g8 e4. g8. a16 g8 e4.
  d'4 d8 h4. c4 c8 g4. 
  a4 a8 c8.[ h16] a8 g8. a16 g8 e4.
  a4 a8 c8.[ h16] a8 g8. a16 g8 e4.
  d'4 d8 f8. d16 h8 c4. ( e4) h8\rest
  c8([ g]) e g f d c4.( c4) h'8\rest
  \bar"|."
}

altMusic = \relative c' {
  e8.( f16) e8 c4. e8. f16 e8 c4.
  f4 f8 f4. e4 e8 e4.
  f4 f8 f8.[ f16] f8 e8. f16 e8 c4.
  f4 f8 a8.[ g16] f8 e8. f16 e8 c4.
  d8[( f)] a g8. g16 g8 g4.( g4) h8\rest
  e,([ c]) c h h h c4.( c4) h'8\rest
  
}

tenorMusic = \relative c' {
  c4 c8 g4. c8. c16 c8 g4.
  h4 h8 d4. c4 c8 c4.
  c4 c8 c8.[ c16] c8 c8. c16 c8 g4.
  c4 c8 c8.[ c16] c8 c8. c16 c8 g4.
  a8([ d]) f h,8.[ c16] d8 c4.( c4) d,8\rest
  g4 g8 g d f e4.( e4) d8\rest
}

bassMusic = \relative c {
  c4 c8 c4. c8. c16 c8 c4.
  g8( h) d g4. c,8( e) g c4.
  f,4 f8 a8.[ g16] f8 c8. c16 c8 c4.
  f,8( a) c f8. f16 f8 c8. c16 c8 c4.
  f4 d8 g8. g16 f8 e4.( c4) d8\rest
  c([ e]) c g g g c4.( c4) d8\rest
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics \altWordsOne
      \addlyrics \altWordsTwo
      \addlyrics \altWordsThree
     >>

    \new Staff <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\addlyrics { \bassWordsOne }
      %\addlyrics { \bassWordsTwo }
      %\addlyrics { \bassWordsFour }
    >>
  >>
>>


\score {
   \myScore
   \layout { }
}

midiOutput = \midi {
    \tempo 4 = 30
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}